#include "solve_dlazaw.hpp"
#include <bits/stdc++.h>
using namespace Solve;
using namespace std;

string sekret;
bool test(string s){
    return sekret.find(s) != string::npos;
}

const int A[] = {10015,10025,10035,10200,11000,15000,20000,30000};
const int B[] = {100, 90, 85, 70, 60, 40, 20, 10, 0};

static int32_t pkt(int32_t zapytania){
    if(zapytania <= A[0]) return B[0];
    if(zapytania > A[7]) return B[7];
    for(int i=0;i<7;i++){
        if(zapytania <= A[i+1]){
            return (int32_t)(B[i+1] + 
            (double)(A[i+1]-zapytania)/(double)(A[i+1]-A[i])*(double)(B[i]-B[i+1]));
        }
    }
    assert(0);
}

int main(int argc, char* argv[]){
    auto& I = Interactor::create(argc, argv);
    auto& input = I.test_reader();
    int N;
    input >> N >> sekret;
    int zapytania = 0;
    I.writer(0) << N << endl;
    while(1){
        string tryb, arg;
        I.reader(0) >> tryb >> arg;
        if(arg.find_first_not_of("01") != string::npos){
            I.end(0, "Zostal wczytany nieoczekiwany znak.");
        }
        if(tryb == "?"){
            zapytania++;
            I.writer(0) << (test(arg) ? '1' : '0') << endl;
        } else if(tryb == "!"){
            if(arg != sekret){
                I.end(0, "Niepoprawnie odczytano sekwencje BNA.");
            } else{
                string kom = "Poprawnie odczytano sekwencje BNA. (" + to_string(zapytania) + " zapytan, " + to_string(pkt(zapytania)) + " pkt).";
                I.end(pkt(zapytania), kom);
            }
        } else{
            I.end(0, "Zostal wczytany nieoczekiwany znak.");
        }
    }

    return 0;
}